/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.mixin.client.audio.ISoundHandlerMixin;
import noppes.npcs.api.mixin.client.audio.ISoundManagerMixin;
import noppes.npcs.api.mixin.client.gui.IGuiYesNoMixin;
import noppes.npcs.api.wrapper.BlockWrapper;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.client.ClientGuiEventHandler;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.player.GuiLog;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.client.util.MusicData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.TempFile;
import noppes.npcs.util.Util;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ClientTickHandler {
    public static boolean checkMails = false;
    public static boolean inGame = false;
    public static Map<ISound, MusicData> musics = new HashMap<ISound, MusicData>();
    private boolean otherContainer = false;
    private World prevWorld;
    public final Map<String, ISound> nowPlayingSounds = new HashMap<String, ISound>();
    public static long ticks = 0L;

    public static void loadFiles() {
        if (ClientProxy.loadFiles.isEmpty()) {
            return;
        }
        String isDel = "";
        Iterator<String> iterator = ClientProxy.loadFiles.keySet().iterator();
        if (iterator.hasNext()) {
            String key = iterator.next();
            TempFile file = ClientProxy.loadFiles.get(key);
            if (file.lastLoad == 0L) {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.GetFilePart, file.getNextPart(), key);
                file.lastLoad = System.currentTimeMillis();
            } else if (file.lastLoad + 12000L < System.currentTimeMillis()) {
                ++file.tryLoads;
                if (file.tryLoads > 9) {
                    LogWriter.error("Failed to load file after 10 attempts: \"" + key + "\"");
                    isDel = key;
                } else {
                    NoppesUtilPlayer.sendData(EnumPlayerPacket.GetFilePart, file.getNextPart(), key);
                    file.lastLoad = System.currentTimeMillis();
                }
            }
        }
        if (!isDel.isEmpty()) {
            ClientProxy.loadFiles.remove(isDel);
            ClientTickHandler.loadFiles();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void npcClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        CustomNpcs.debugData.start(null);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && ClientProxy.playerData.getPlayer() == null) {
            ClientProxy.playerData.setPlayer((EntityPlayer)mc.field_71439_g);
        }
        if (mc.field_71439_g != null && mc.field_71439_g.field_71070_bA instanceof ContainerPlayer) {
            if (this.otherContainer) {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.CheckQuestCompletion, 0);
                this.otherContainer = false;
            }
        } else {
            this.otherContainer = true;
        }
        if (mc.field_71439_g == null) {
            if (inGame) {
                LogWriter.debug("Client Player: Exit game");
                inGame = false;
                ScriptController.Instance.clientScripts.saveDefaultScripts();
                EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.LOGOUT, (Event)new PlayerEvent.LogoutEvent((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)mc.field_71439_g)));
            } else if (!ScriptController.Instance.clientScripts.loadDefault) {
                ScriptController.Instance.clientScripts.loadDefaultScripts();
            }
        }
        char c0 = Keyboard.getEventCharacter();
        if ((Keyboard.getEventKey() == 0 && c0 >= ' ' || Keyboard.getEventKeyState()) && mc.field_71462_r instanceof GuiYesNo) {
            GuiYesNoCallback parentScreen;
            if (Keyboard.getEventKey() == 1) {
                parentScreen = ((IGuiYesNoMixin)mc.field_71462_r).npcs$getParentScreen();
                parentScreen.func_73878_a(false, ((IGuiYesNoMixin)mc.field_71462_r).npcs$getParentButtonClickedId());
            }
            if (Keyboard.getEventKey() == 28) {
                parentScreen = ((IGuiYesNoMixin)mc.field_71462_r).npcs$getParentScreen();
                parentScreen.func_73878_a(true, ((IGuiYesNoMixin)mc.field_71462_r).npcs$getParentButtonClickedId());
            }
        }
        ++ticks;
        ++RenderNPCInterface.LastTextureTick;
        if (this.prevWorld != mc.field_71441_e) {
            this.prevWorld = mc.field_71441_e;
            MusicController.Instance.stopSounds();
        }
        SoundManager sm = ((ISoundHandlerMixin)mc.func_147118_V()).npcs$getSndManager();
        Map<String, ISound> playingSounds = ((ISoundManagerMixin)sm).npcs$getPlayingSounds();
        ArrayList<String> del = new ArrayList<String>();
        if (playingSounds != null) {
            ISound sound;
            for (String uuid : playingSounds.keySet()) {
                try {
                    if (this.nowPlayingSounds.containsKey(uuid) && this.nowPlayingSounds.containsValue(playingSounds.get(uuid))) continue;
                    sound = playingSounds.get(uuid);
                    if (sound.func_184365_d() == SoundCategory.MUSIC && !musics.containsKey(sound)) {
                        musics.put(sound, new MusicData(sound, uuid, sm));
                    }
                    this.nowPlayingSounds.put(uuid, playingSounds.get(uuid));
                    NoppesUtilPlayer.sendData(EnumPlayerPacket.PlaySound, sound.func_184364_b().func_188719_a(), sound.func_147650_b(), sound.func_184365_d().func_187948_a(), Float.valueOf(sound.func_147649_g()), Float.valueOf(sound.func_147654_h()), Float.valueOf(sound.func_147651_i()), Float.valueOf(sound.func_147653_e()), Float.valueOf(sound.func_147655_f()));
                    EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.SOUND_PLAY, (Event)new PlayerEvent.PlayerSound((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)mc.field_71439_g), sound.func_184364_b().func_188719_a().toString(), sound.func_147650_b().toString(), sound.func_184365_d().func_187948_a(), sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i(), sound.func_147653_e(), sound.func_147655_f()));
                }
                catch (Exception e) {
                    LogWriter.error("Error set played sound: " + e);
                    del.add(uuid);
                }
            }
            for (String uuid : this.nowPlayingSounds.keySet()) {
                try {
                    if (playingSounds.containsKey(uuid) && playingSounds.containsValue(this.nowPlayingSounds.get(uuid))) continue;
                    sound = this.nowPlayingSounds.get(uuid);
                    musics.remove(sound);
                    NoppesUtilPlayer.sendData(EnumPlayerPacket.StopSound, sound.func_184364_b().func_188719_a(), sound.func_147650_b(), sound.func_184365_d().func_187948_a(), Float.valueOf(sound.func_147649_g()), Float.valueOf(sound.func_147654_h()), Float.valueOf(sound.func_147651_i()), Float.valueOf(sound.func_147653_e()), Float.valueOf(sound.func_147655_f()));
                    EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.SOUND_STOP, (Event)new PlayerEvent.PlayerSound((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)mc.field_71439_g), sound.func_184364_b().func_188719_a().toString(), sound.func_147650_b().toString(), sound.func_184365_d().func_187948_a(), sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i(), sound.func_147653_e(), sound.func_147655_f()));
                    del.add(uuid);
                }
                catch (Exception e) {
                    LogWriter.error("Error stop played sound: " + e);
                    del.add(uuid);
                }
            }
        }
        for (String uuid : del) {
            this.nowPlayingSounds.remove(uuid);
        }
        for (MusicData md : musics.values()) {
            if (md.sound == null || md.source == null || md.source.paused()) continue;
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.SOUND_TICK_EVENT, (Event)md.createEvent(CustomNpcs.proxy.getPlayer()));
        }
        if (ticks % 10L == 0L) {
            MarcetController.getInstance().updateTime();
            ClientTickHandler.loadFiles();
            if (mc.field_71442_b != null) {
                double d1;
                double d0 = mc.field_71442_b.func_78757_d();
                if (mc.field_71442_b.func_78749_i()) {
                    d0 = 6.0;
                }
                if (ClientProxy.playerData.game.blockReachDistance != d0) {
                    ClientProxy.playerData.game.blockReachDistance = d0;
                    ClientProxy.playerData.game.updateClient = true;
                }
                if (ClientProxy.playerData.game.renderDistance != (d1 = (double)mc.field_71474_y.func_74296_a(GameSettings.Options.RENDER_DISTANCE) * 16.0)) {
                    ClientProxy.playerData.game.renderDistance = d1;
                    ClientProxy.playerData.game.updateClient = true;
                }
            } else {
                ClientProxy.playerData.game.blockReachDistance = 0.0;
                ClientProxy.playerData.game.renderDistance = 0.0;
                ClientProxy.playerData.game.updateClient = true;
            }
            if (mc.field_71439_g != null) {
                MusicController.Instance.checkBards((EntityPlayer)mc.field_71439_g);
                if (ClientProxy.playerData.game.updateClient) {
                    NoppesUtilPlayer.sendData(EnumPlayerPacket.SendSyncData, new Object[]{EnumSync.GameData, ClientProxy.playerData.game.saveNBTData(new NBTTagCompound())});
                    ClientProxy.playerData.game.updateClient = false;
                }
            }
        }
        if (ticks % 60L == 0L) {
            BlockWrapper.checkClearCache();
        }
        if (ScriptController.Instance.clientScripts.isEnabled()) {
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.TICK, (Event)new PlayerEvent.UpdateEvent((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)mc.field_71439_g)));
        }
        if (checkMails || CustomNpcs.MailWindow != -1 && ticks % 100L == 0L) {
            boolean hasNewMail = false;
            long time = System.currentTimeMillis();
            for (PlayerMail mail : ClientProxy.playerData.mailData.playerMails) {
                if (mail.beenRead || time - mail.timeWhenReceived < mail.timeWillCome) continue;
                hasNewMail = true;
                break;
            }
            if (hasNewMail != ClientGuiEventHandler.hasNewMail) {
                ClientGuiEventHandler.hasNewMail = hasNewMail;
                if (hasNewMail) {
                    ClientGuiEventHandler.showNewMail = 0L;
                    ClientGuiEventHandler.startMail = 0L;
                    mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("mailbox.new.letters.received", new Object[0]));
                }
            }
            checkMails = false;
        }
        if (mc.field_71462_r != null && !ClientProxy.playerData.hud.keyPress.isEmpty()) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.KeyPressed, -1);
            ClientProxy.playerData.hud.keyPress.clear();
        }
        if (mc.field_71462_r instanceof GuiNPCInterface || mc.field_71462_r instanceof GuiContainerNPCInterface) {
            SubGuiInterface subGui = mc.field_71462_r instanceof GuiNPCInterface ? ((GuiNPCInterface)mc.field_71462_r).getSubGui() : ((GuiContainerNPCInterface)mc.field_71462_r).getSubGui();
            if (subGui != null && subGui.getSubGui() != null) {
                while (subGui.getSubGui() != null) {
                    subGui = subGui.getSubGui();
                }
            }
            if (ClientEventHandler.subgui != subGui) {
                LogWriter.debug((subGui == null ? "Close SubGUI " : "Open SubGUI - " + subGui.getClass()) + "; SubOLD - " + (ClientEventHandler.subgui == null ? "null" : ClientEventHandler.subgui.getClass().getSimpleName()) + "; in GUI " + (mc.field_71462_r != null ? mc.field_71462_r.getClass().getSimpleName() : "NULL"));
                ClientEventHandler.subgui = subGui;
            }
        }
        CustomNpcs.debugData.end(null);
    }

    @SubscribeEvent
    public void npcKeyInputEvent(InputEvent.KeyInputEvent event) {
        CustomNpcs.debugData.start(null);
        Minecraft mc = Minecraft.func_71410_x();
        if (ClientProxy.QuestLog.func_151468_f()) {
            if (mc.field_71462_r == null) {
                CustomNpcs.proxy.openGui(0, 0, 0, EnumGuiType.QuestLog, (EntityPlayer)mc.field_71439_g);
            } else if (mc.field_71462_r instanceof GuiLog) {
                mc.func_71381_h();
            }
        }
        if (mc.field_71462_r == null) {
            boolean isCtrlPressed = ClientProxy.playerData.hud.hasOrKeysPressed(157, 29);
            boolean isShiftPressed = ClientProxy.playerData.hud.hasOrKeysPressed(54, 42);
            boolean isAltPressed = ClientProxy.playerData.hud.hasOrKeysPressed(184, 56);
            boolean isMetaPressed = ClientProxy.playerData.hud.hasOrKeysPressed(220, 219);
            boolean isDown = Keyboard.getEventKeyState();
            int key = Keyboard.getEventKey();
            if (isDown) {
                ClientProxy.playerData.hud.keyPress.add(key);
                ClientProxy.pressed(key);
                if (key == 29 || key == 157) {
                    isCtrlPressed = true;
                }
                if (key == 42 || key == 54) {
                    isShiftPressed = true;
                }
                if (key == 56 || key == 184) {
                    isAltPressed = true;
                }
                if (key == 219 || key == 220) {
                    isMetaPressed = true;
                }
            } else {
                if (ClientProxy.playerData.hud.hasOrKeysPressed(key)) {
                    ClientProxy.playerData.hud.keyPress.remove((Object)key);
                }
                if (key == 29 || key == 157) {
                    isCtrlPressed = false;
                }
                if (key == 42 || key == 54) {
                    isShiftPressed = false;
                }
                if (key == 56 || key == 184) {
                    isAltPressed = false;
                }
                if (key == 219 || key == 220) {
                    isMetaPressed = false;
                }
            }
            NoppesUtilPlayer.sendData(EnumPlayerPacket.KeyPressed, key, isDown, isCtrlPressed, isShiftPressed, isAltPressed, isMetaPressed);
        } else if (!ClientProxy.playerData.hud.keyPress.isEmpty()) {
            ClientProxy.playerData.hud.keyPress.clear();
            NoppesUtilPlayer.sendData(EnumPlayerPacket.KeyPressed, -1);
        }
        CustomNpcs.debugData.end(null);
    }

    @SubscribeEvent
    public void npcLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        CustomNpcs.debugData.start(null);
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        NoppesUtilPlayer.sendData(EnumPlayerPacket.LeftClick, new Object[0]);
        CustomNpcs.debugData.end(null);
    }

    @SubscribeEvent
    public void npcLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof EntityNPCInterface)) {
            return;
        }
        CustomNpcs.debugData.start(null);
        int dimID = Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
        if (ClientProxy.notVisibleNPC.containsKey(dimID) && ClientProxy.notVisibleNPC.get(dimID).contains(event.getEntity().func_110124_au())) {
            Minecraft.func_71410_x().field_71441_e.func_72900_e(event.getEntity());
        }
        CustomNpcs.debugData.end(null);
    }

    @SubscribeEvent
    public void npcLoadAllOBJTextures(TextureStitchEvent.Pre event) {
        CustomNpcs.debugData.start(null);
        File assets = new File(CustomNpcs.Dir, "assets/customnpcs");
        if (!assets.exists()) {
            CustomNpcs.debugData.end(null);
            return;
        }
        ArrayList<ResourceLocation> objTextures = new ArrayList<ResourceLocation>();
        for (File file : Util.instance.getFiles(assets, ".mtl")) {
            try {
                for (String line : Files.readAllLines(file.toPath())) {
                    String path;
                    if (!line.contains("map_Kd")) continue;
                    int endIndex = line.indexOf("\n", line.indexOf("map_Kd"));
                    if (endIndex == -1) {
                        endIndex = line.length();
                    }
                    String txtr = line.substring(line.indexOf(" ", line.indexOf("map_Kd")) + 1, endIndex);
                    String domain = "";
                    if (!txtr.contains(":")) {
                        path = txtr;
                    } else {
                        domain = txtr.substring(0, txtr.indexOf(":"));
                        path = txtr.substring(txtr.indexOf(":") + 1);
                    }
                    objTextures.add(new ResourceLocation(domain, path));
                }
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
        }
        for (ResourceLocation res : objTextures) {
            if (event.getMap().getTextureExtry(res.toString()) != null) continue;
            event.getMap().func_174942_a(res);
        }
        CustomNpcs.debugData.end(null);
    }

    @SubscribeEvent
    public void npcGuiScreenMouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        this.npcMouseInput(Mouse.getEventButton(), Mouse.getEventX(), Mouse.getEventY(), Mouse.getEventDX(), Mouse.getEventDY(), Mouse.getEventDWheel(), Mouse.getEventButtonState());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void npcMouseInput(MouseEvent event) {
        this.npcMouseInput(event.getButton(), event.getX(), event.getY(), event.getDx(), event.getDy(), event.getDwheel(), event.isButtonstate());
    }

    public void npcMouseInput(int key, int x, int y, int dx, int dy, int dWheel, boolean isDown) {
        CustomNpcs.debugData.start(null);
        boolean isCtrlPressed = GuiScreen.func_146271_m();
        boolean isShiftPressed = GuiScreen.func_146272_n();
        boolean isAltPressed = GuiScreen.func_175283_s();
        boolean isMetaPressed = Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220);
        IPlayer iPlayer = (IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)Minecraft.func_71410_x().field_71439_g);
        if (key < 0) {
            PlayerEvent.MouseMoveEvent event = new PlayerEvent.MouseMoveEvent(iPlayer, x, y, dx, dy, dWheel, isCtrlPressed, isShiftPressed, isAltPressed, isMetaPressed);
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.MOUSE_MOVE, (Event)event);
            CustomNpcs.debugData.end(null);
            return;
        }
        PlayerEvent.KeyPressedEvent event = new PlayerEvent.KeyPressedEvent(iPlayer, key, isCtrlPressed, isAltPressed, isShiftPressed, isMetaPressed);
        EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, isDown ? EnumScriptType.MOUSE_DOWN : EnumScriptType.MOUSE_UP, (Event)event);
        NoppesUtilPlayer.sendData(EnumPlayerPacket.MousesPressed, key, isDown, isCtrlPressed, isShiftPressed, isAltPressed, isMetaPressed, dWheel);
        if (isDown) {
            ClientProxy.playerData.hud.mousePress.add(key);
        } else if (ClientProxy.playerData.hud.hasMousePress(key)) {
            ClientProxy.playerData.hud.mousePress.remove((Object)key);
        }
        CustomNpcs.debugData.end(null);
    }
}

